% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.region.values.on.subject}
\alias{vis.region.values.on.subject}
\title{Visualize arbitrary data, one value per atlas region, on the surface of any subject (including template subjects).}
\usage{
vis.region.values.on.subject(subjects_dir, subject_id, atlas,
  lh_region_value_list, rh_region_value_list, surface = "white",
  colormap = grDevices::heat.colors, views = c("t4"),
  rgloptions = list(), rglactions = list(),
  value_for_unlisted_regions = NaN, draw_colorbar = FALSE)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, containing the subdir of vis_subject_id, the subject that you want to use for visualization.}

\item{subject_id, }{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{atlas, }{string. The brain atlas to use. E.g., 'aparc' or 'aparc.a2009s'.}

\item{lh_region_value_list, }{named list. A list for the left hemisphere in which the names are atlas regions, and the values are the value to write to all vertices of that region.}

\item{rh_region_value_list, }{named list. A list for the right hemisphere in which the names are atlas regions, and the values are the value to write to all vertices of that region.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap function. See the squash package for some colormaps. Defaults to [grDevices::heat.colors].}

\item{views, }{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to [rgl::par3d()]. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}

\item{rglactions, }{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{value_for_unlisted_regions}{numerical scalar or NaN, the value to assign to regions which do not occur in the region_value_lists. Defaults to NaN.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
This function can be used for rendering a single value (color) for all vertices of an atlas region. The typical usecase is the visualization of results of atlas-based analyses, e.g., p-value, means or other aggregated values over all vertices of a region.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   atlas = 'aparc';   # Desikan atlas
   # For the left hemisphere, we just assign a subset of the
   # atlas regions. The others will get the default value.
   lh_region_value_list = list("bankssts"=0.9, "precuneus"=0.7, "postcentral"=0.8, "lingual"=0.6);
   # For the right hemisphere, we retrieve the full list of regions for
   # the atlas, and assign random values to all of them.
   atlas_region_names = get.atlas.region.names(atlas, template_subjects_dir = subjects_dir,
    template_subject='subject1');
   rh_region_value_list = rnorm(length(atlas_region_names), 3.0, 1.0);
   names(rh_region_value_list) = atlas_region_names;
   vis.region.values.on.subject(subjects_dir, 'subject1', atlas,
    lh_region_value_list, rh_region_value_list);
}

}
\seealso{
Other visualization functions: \code{\link{vis.data.on.fsaverage}},
  \code{\link{vis.data.on.subject}},
  \code{\link{vis.subject.annot}},
  \code{\link{vis.subject.label}},
  \code{\link{vis.subject.morph.native}},
  \code{\link{vis.subject.morph.standard}}
}
\concept{visualization functions}
