% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{coloredmesh.from.annot}
\alias{coloredmesh.from.annot}
\title{Create a coloredmesh from an annotation of an atlas.}
\usage{
coloredmesh.from.annot(subjects_dir, subject_id, atlas, hemi,
  surface = "white", colormap = squash::jet)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap. See the squash package for some colormaps. Defaults to squash::jet.}
}
\value{
coloredmesh. A named list with entries: "mesh" the rgl::tmesh3d mesh object. "col": the mesh colors. "morph_data_was_all_na", logical. Whether the mesh values were all NA, and thus replaced by the all_nan_backup_value. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from an annotation of an atlas.
}
\keyword{internal}
