% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_global}
\alias{bs_vars_global}
\title{Bootstrap CSS global variables}
\usage{
bs_vars_global(body_bg = NULL, text_color = NULL, link_color = NULL,
  link_hover_color = NULL, line_height_base = NULL,
  grid_columns = NULL, grid_gutter_width = NULL,
  border_radius_base = NULL)
}
\arguments{
\item{body_bg}{Background color for the body.}

\item{text_color}{Global text color on body.}

\item{link_color}{Global textual link color.}

\item{link_hover_color}{Link hover color.}

\item{line_height_base}{Unit-less `line-height` for use in components like buttons.}

\item{grid_columns}{Number of columns in the grid, e.g. in \code{\link[shiny:fluidPage]{shiny::fluidRow(shiny::column(...))}}.}

\item{grid_gutter_width}{Padding between columns. Gets divided in half for the left and right.}

\item{border_radius_base}{Base border radius (rounds the corners of elements).}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 Bootstrap and Bootswatch themes.
}
\examples{
# change background color
bs_vars_global(
  body_bg = "#FAFAFA"
)

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    use_theme(
      create_theme(
        theme = "default",
        bs_vars_global(
          body_bg = "#F5A9E1",
          text_color = "#FFF",
          grid_columns = 16
        ),
        output_file = NULL
      )
    ),
    tags$h1("My custom app!"),
    tags$h3("With plenty of columns!"),
    fluidRow(
      column(
        width = 1, "Column 1"
      ),
      column(
        width = 1, "Column 2"
      ),
      column(
        width = 1, "Column 3"
      ),
      column(
        width = 1, "Column 4"
      ),
      column(
        width = 1, "Column 5"
      ),
      column(
        width = 1, "Column 6"
      ),
      column(
        width = 1, "Column 7"
      ),
      column(
        width = 1, "Column 8"
      ),
      column(
        width = 1, "Column 9"
      ),
      column(
        width = 1, "Column 10"
      ),
      column(
        width = 1, "Column 11"
      ),
      column(
        width = 1, "Column 12"
      ),
      column(
        width = 1, "Column 13"
      ),
      column(
        width = 1, "Column 14"
      ),
      column(
        width = 1, "Column 15"
      ),
      column(
        width = 1, "Column 16"
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
