% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_vect.R
\name{freq_vect}
\alias{freq_vect}
\title{freq_vect}
\usage{
freq_vect(data_vector, sort_by_count = FALSE, total_row = TRUE)
}
\arguments{
\item{data_vector}{an atomic vector of type character, integer, double, or logical}

\item{sort_by_count}{boolean value that determines if output will be sorted by count or name}

\item{total_row}{a boolean value that determines if the output will have a summary row appended}
}
\value{
a data_frame containing the counts and percentages of each value from the provided data
}
\description{
freq_vect returns a frequency table with counts and percentages of values
  from an atomic vector of type character, integer, double, or logical
}
\examples{
# Sample vector and data frame to demo the freq_vect function.
numbers <- sample(1:10, 200, replace = TRUE)
tbl     <- data.frame(numbers = sample(1:10, 200, replace = TRUE),
  letters = sample(letters, 200, replace = TRUE),
  dates = sample(seq(as.Date('1999/10/01'), as.Date('2000/01/01'), by="day"),
                 200, replace = TRUE),
  logicals = sample(c(TRUE, FALSE), 200, replace = TRUE),
  stringsAsFactors = FALSE)

freq_vect(numbers)
freq_vect(tbl$numbers)
freq_vect(tbl$letters, sort_by_count = TRUE, total_row = FALSE)
freq_vect(mtcars$cyl)
}
