% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/linproc.R
\name{linproc}
\alias{linproc}
\title{Generate a linear process from}
\usage{
linproc(X, A, noise = NULL)
}
\arguments{
\item{X}{process process}

\item{A}{time-domain operator series}

\item{noise}{function taking dimension D and returning D-dimentional vector}
}
\value{
Multivariate linear process
}
\description{
Compute
\deqn{Y_t = \sum_{k=-q}^p A_k X_{t-k}}
where \eqn{X_t} is a stationary multivariate time series and \eqn{(A_k)_{-q \leq k \leq p}} is a filter.
}
\examples{
d = 2
n = 100
X = rar(n,d=d)

OP = array(0,c(d,d,2))
OP[,,1] = 2 * diag(d:1)/d
OP[,,2] = 1.5 * diag(d:1)/d
A = timedom(OP, 0:1)

Y = linproc(X,A,noise=rnorm)
}
\seealso{
\code{\link{speclagreg}}
}

