% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_request.R
\name{fredr_request}
\alias{fredr_request}
\title{Send a request to the FRED API}
\usage{
fredr_request(
  endpoint,
  ...,
  to_frame = TRUE,
  print_req = FALSE,
  retry_times = 3L
)
}
\arguments{
\item{endpoint}{A string representing the FRED API endpoint of interest. See
\link{fredr_endpoints} for a list of endpoint possible values. \emph{Required
parameter.}}

\item{...}{A series of named parameters to be used in the query.  Must be of
the form \code{param_key = "param_value"}.  Acceptable parameters are
endpoint-specific. See the \link{fredr_endpoints} data frame for a list of
endpoints and \code{\link[=fredr_docs]{fredr_docs()}} to access the web documentation for each
endpoint function.}

\item{to_frame}{A boolean value indicating whether or not the response should
be parsed and formatted as a data frame.  If \code{FALSE}, a \code{response} object
is returned and further processing can be done with \code{\link[httr:content]{httr::content()}}.
Default is \code{TRUE}.}

\item{print_req}{A boolean value indicating whether or not the request should
be printed as well.  Useful for debugging.  Default is \code{FALSE}.}

\item{retry_times}{An integer indicating the maximum number of requests to
attempt. Passed directly to \code{\link[httr:RETRY]{httr::RETRY()}}.  Default is 3.}
}
\value{
If \code{to_frame = TRUE}, a \code{tibble} containing the parsed response. If
\code{to_frame = FALSE}, a \code{response} object returned directly from
\code{\link[httr:GET]{httr::GET()}}.
}
\description{
Send a general request to the FRED API by specifying an endpoint and a
sequence of parameters.  The \code{fredr_request()} function forms and submits a
request to a specified endpoint of the FRED API.  The result is either the
\code{response} object from \code{\link[httr:GET]{httr::GET()}} or the response parsed as a \code{tibble}.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/}{FRED API}
}

\examples{
if (fredr_has_key()) {
fredr_request(
  endpoint = "series/observations",
  series_id = "GNPCA",
  observation_start = "1990-01-01",
  observation_end = "2000-01-01"
)

# Compare to to_frame = `FALSE`
resp <- fredr_request(
  endpoint = "series/observations",
  series_id = "GNPCA",
  observation_start = "1990-01-01",
  observation_end = "2000-01-01",
  to_frame = FALSE
)
}
}
