% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_missing.R
\name{filter_missing}
\alias{filter_missing}
\alias{filter_missing.data.frame}
\title{filter out missings}
\usage{
filter_missing(.data, ..., remove_inf = TRUE)

\method{filter_missing}{data.frame}(.data, ..., remove_inf = TRUE, condition = c("any", "all"))
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect. default selection is all columns}

\item{remove_inf}{logical. default is to also remove Inf values. set to False otherwise.}

\item{condition}{defaults to "any". in which case removes rows if NA is in any specified column. "all" will remove rows only if each specified column is NA}
}
\value{
data frame
}
\description{
More complex wrapper around filter(!is.na()) to remove NA rows using tidyselect. If any specified column contains an NA
the whole row is removed. Reports the amount of rows removed containing NaN, Na, Inf, in that order.
For example if one row contains Inf in one column and Na in another, the removed row will be counted in the Na tally.
}
\details{
S3 method, can also be used on vectors
}
\examples{

tibble::tibble(x = c(NA, 1L, 2L, NA, NaN, 5L, Inf),
y = c(1L, NA, 2L, NA, Inf, 5L, Inf)) -> tbl1

tbl1 \%>\%
filter_missing()

tbl1 \%>\%
filter_missing(x, remove_inf = FALSE)

tbl1 \%>\%
filter_missing(condition = "all")
}
