\name{fracdiff.sim}
\alias{fracdiff.sim}
\title{Simulate fractional ARIMA Time Series}
\description{
  Generates simulated long-memory time series data from the
  fractional ARIMA(p,d,q) model.  This is a test problem generator for
  \code{\link{fracdiff}}.
}
\usage{
fracdiff.sim(n, ar = NULL, ma = NULL, d,
             rand.gen = rnorm, innov = rand.gen(n+q, ...),
             n.start = NA, allow.0.nstart = FALSE, ..., mu = 0.)
}
\arguments{
  \item{n}{length of the time series.}
  \item{ar}{vector of autoregressive parameters; empty by default.}
  \item{ma}{vector of moving average parameters; empty by default.}
  \item{d}{fractional differencing parameter.}
  \item{rand.gen}{a function to generate the innovations; the default,
    \code{\link{rnorm}} generates white N(0,1) noise.}
  \item{innov}{an optional times series of innovations.  If not
    provided, \code{rand.gen()} is used.}
  \item{n.start}{length of \dQuote{burn-in} period.  If \code{NA}, the
    default, the same value as in \code{\link{arima.sim}} is computed.}
  \item{allow.0.nstart}{logical indicating if \code{n.start = 0} should
    be allowed even when \eqn{p + q > 0}.  This not recommended unless
    for producing the same series as with older versions of \code{fracdiff.sim}.}
  \item{\dots}{additional arguments for \code{rand.gen()}.  Most usefully,
    the standard deviation of the innovations generated by \code{rnorm}
    can be specified by \code{sd}.}
  \item{mu}{time series mean (added at the end).}
}
\value{
  a list containing the following elements :
  \item{series}{time series}
  \item{ar, ma, d, mu, n.start}{same as input}
}
\seealso{
  \code{\link{fracdiff}}, also for references;
  \code{\link[stats]{arima.sim}}
}
\examples{
## Pretty (too) short to "see" the long memory
fracdiff.sim(100, ar = .2, ma = .4, d = .3)

## longer with "extreme" ar:
r <- fracdiff.sim(n=1500, ar=-0.9, d= 0.3)
plot(as.ts(r$series))
}
\keyword{ts}
