% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\title{Converts a (possibly compound) value into a string using the \code{format} information}
\usage{
format_value(x, format = NULL, output = c("ascii", "html"), na_str = "NA")
}
\arguments{
\item{x}{(\code{ANY})\cr the value to be formatted.}

\item{format}{(\code{string} or \code{function})\cr the format label (string) or formatter function to
apply to \code{x}.}

\item{output}{(\code{string})\cr output type.}

\item{na_str}{(\code{string})\cr string to display when the value of \code{x} is missing. Defaults to \code{"NA"}.}
}
\value{
Formatted text representing the cell \code{x}.
}
\description{
Converts a (possibly compound) value into a string using the \code{format} information
}
\details{
A length-zero value for \code{na_str} will be interpreted as \code{"NA"}, as will any
missing values within a non-length-zero \code{na_str} vector.
}
\examples{
x <- format_value(pi, format = "xx.xx")
x

format_value(x, output = "ascii")

}
\seealso{
\code{\link[=round_fmt]{round_fmt()}}
}
