% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattable.R
\name{formattable.data.frame}
\alias{formattable.data.frame}
\title{Create a formattable data frame}
\usage{
\method{formattable}{data.frame}(x, ..., formatter = "format_table",
  preproc = NULL, postproc = NULL)
}
\arguments{
\item{x}{a \code{data.frame}}

\item{...}{arguments to be passed to \code{formatter}.}

\item{formatter}{formatting function, \code{format_table} in default.}

\item{preproc}{pre-processor function that prepares \code{x} for
formatting function.}

\item{postproc}{post-processor function that transforms formatted
output for printing.}
}
\value{
a \code{formattable data.frame}
}
\description{
This function creates a formattable data frame by attaching
column or area formatters to the data frame. Each time the data frame
is printed or converted to string representation, the formatter
function will use the formatter functions to generate
formatted cells.
}
\details{
The formattable data frame is a data frame with lazy-bindings
of prespecified column formatters or area formatters.
The formatters will not be applied until the data frame is
printed to console or in a dynamic document. If the formatter
function has no side effect, the formattable data frame will
not be changed even if the formatters are applied to produce
the printed version.
}
\examples{
# mtcars (mpg in red)
formattable(mtcars,
   list(mpg = formatter("span", style = "color:red")))

# mtcars (mpg in red if greater than median)
formattable(mtcars, list(mpg = formatter("span",
   style = function(x) ifelse(x > median(x), "color:red", NA))))

# mtcars (mpg in red if greater than median, using formula)
formattable(mtcars, list(mpg = formatter("span",
   style = x ~ ifelse(x > median(x), "color:red", NA))))

# mtcars (mpg in gradient: the higher, the redder)
formattable(mtcars, list(mpg = formatter("span",
   style = x ~ style(color = rgb(x/max(x), 0, 0)))))

# mtcars (mpg background in gradient: the higher, the redder)
formattable(mtcars, list(mpg = formatter("span",
   style = x ~ style(display = "block",
   "border-radius" = "4px",
   "padding-right" = "4px",
   color = "white",
   "background-color" = rgb(x/max(x), 0, 0)))))

# mtcars (mpg in red if vs == 1 and am == 1)
formattable(mtcars, list(mpg = formatter("span",
    style = ~ style(color = ifelse(vs == 1 & am == 1, "red", NA)))))

# hide columns
formattable(mtcars, list(mpg = FALSE, cyl = FALSE))

# area formatting
formattable(mtcars, list(area(col = vs:carb) ~ formatter("span",
  style = x ~ style(color = ifelse(x > 0, "red", NA)))))

df <- data.frame(a = rnorm(10), b = rnorm(10), c = rnorm(10))
formattable(df, list(area() ~ color_tile("transparent", "lightgray")))
formattable(df, list(area(1:5) ~ color_tile("transparent", "lightgray")))
formattable(df, list(area(1:5) ~ color_tile("transparent", "lightgray"),
  area(6:10) ~ color_tile("transparent", "lightpink")))
}
\seealso{
\link{format_table}, \link{area}
}

