% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeci.R
\name{make_summary}
\alias{make_summary}
\title{Create pooled summary diamond shape}
\usage{
make_summary(est, lower, upper, sizes = 1, gp, xlim, nudge_y = NULL)
}
\arguments{
\item{est}{Point estimation. Can be a list for multiple columns
and/or multiple groups. If the length of the list is larger than
then length of \code{ci_column}, then the values reused for each column
and considered as different groups.}

\item{lower}{Lower bound of the confidence interval, same as \code{est}.}

\item{upper}{Upper bound of the confidence interval, same as \code{est}.}

\item{sizes}{Size of the point estimation box, can be a unit, vector or a list.
Values will be used as it is, no transformation will be applied.}

\item{gp}{Graphical parameters of \code{\link[grid]{gpar}}.
Please refer to \code{\link{forest_theme}} for more details.}

\item{xlim}{Limits for the x axis as a vector of length 2, i.e. c(low, high). It
will take the minimum and maximum of the lower and upper value if not provided.
This will apply to all CI columns if provided, and will be calculated automatically
for each column if not provided. This should be a list with the same length of
\code{ci_column} if different \code{xlim} for different column is desired.}

\item{nudge_y}{Horizontal adjustment to nudge groups by, must be within 0 to 1.}
}
\value{
A gTree object
}
\description{
Create pooled summary diamond shape
}
