% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_set_style.R
\name{fp_set_style}
\alias{fp_set_style}
\title{Set the style of the graph}
\usage{
fp_set_style(
  x,
  default = NULL,
  box = NULL,
  lines = NULL,
  vertices = NULL,
  summary = NULL,
  zero = NULL,
  axes = NULL,
  hrz_lines = NULL,
  grid = NULL,
  txt_gp = NULL
)
}
\arguments{
\item{x}{The forestplot object}

\item{default}{A fallback \link[grid:gpar]{grid::gpar} for all unspecified attributes.
If set to NULL then it defaults to legacy parameters, including
the \code{col}, \code{lwd.xaxis}, \code{lwd.ci} and \code{lty.ci}
parameter of \code{fpColors}.}

\item{box}{The graphical parameters (\code{gpar}, \code{character}) of the box, circle
or point indicating the point estimate, i.e. the middle
of the confidence interval (may be a list of gpars). If provided
a string a \code{gpar} will be generated with \code{col}, and \code{fill} for
those arguments.}

\item{lines}{The graphical parameters (\code{gpar}, \code{character}) of the confidence lines
(may be a list of gpars). If provided a string a \code{gpar} will be generated
with \code{col} as the only arguments.}

\item{vertices}{The graphical parameters (\code{gpar}, \code{character}) of the vertices
(may be a list of gpars).
If \code{ci.vertices} is set to TRUE in \code{forestplot}
\code{vertices} inherits from \code{lines} all its parameters but lty that is set
to "solid" by default.}

\item{summary}{The graphical parameters (\code{gpar}, \code{character}) of the summary
(may be a list of gpars). If provided a string a \code{gpar} will be generated with
\code{col}, and \code{fill} for those arguments.}

\item{zero}{The graphical parameters (\code{gpar}) of the zero line
(may not be a list of gpars). If provided a string a \code{gpar} will be generated
with \code{col} as the only arguments.}

\item{axes}{The graphical parameters (\code{gpar}) of the x-axis at the bottom
(may not be a list of gpars).}

\item{hrz_lines}{The graphical parameters (\code{gpar}) of the horizontal lines
(may not be a list of gpars). If provided a string a \code{gpar} will be generated
with \code{col} as the only arguments.}

\item{grid}{The graphical parameters (\code{gpar}) of the grid (vertical lines)
(may be a list of gpars). If provided a string a \code{gpar} will be generated
with \code{col} as the only arguments.}

\item{txt_gp}{Set the fonts etc for all text elements. See \code{\link[=fpTxtGp]{fpTxtGp()}}
for details}
}
\value{
The foresplot object with the styles
}
\description{
Sets the output style associated with the \code{foresplot}
}
\examples{
base_data <- tibble::tibble(mean  = c(0.578, 0.165, 0.246, 0.700, 0.348, 0.139, 1.017),
                            lower = c(0.372, 0.018, 0.072, 0.333, 0.083, 0.016, 0.365),
                            upper = c(0.898, 1.517, 0.833, 1.474, 1.455, 1.209, 2.831),
                            study = c("Auckland", "Block", "Doran", "Gamsu",
                                      "Morrison", "Papageorgiou", "Tauesch"),
                            deaths_steroid = c("36", "1", "4", "14", "3", "1", "8"),
                            deaths_placebo = c("60", "5", "11", "20", "7", "7", "10"),
                            OR = c("0.58", "0.16", "0.25", "0.70", "0.35", "0.14", "1.02"))

base_data |>
  forestplot(labeltext = c(study, deaths_steroid, deaths_placebo, OR),
             clip = c(0.1, 2.5),
             xlog = TRUE) |>
  fp_add_header(study = c("", "Study"),
                deaths_steroid = c("Deaths", "(steroid)"),
                deaths_placebo = c("Deaths", "(placebo)"),
                OR = c("", "OR")) |>
  fp_set_style(box = "royalblue",
               line = "darkblue",
               summary = gpar(fill = "royalblue", clr = "black"),
               txt_gp = fpTxtGp(label = gpar(fontfamily = "mono")))
}
\seealso{
Other graph modifiers: 
\code{\link{fp_decorate_graph}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_zebra_style}()}
}
\concept{graph modifiers}
