% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_center.R
\name{class_center}
\alias{class_center}
\title{Classify a given variable and get center of class}
\usage{
class_center(df, y, ci = 3, ymin = 5)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Quoted name of a variable, or a vector to be classified.}

\item{ci}{Numeric value for the class interval used to classify the data. Default: \code{3}.}

\item{ymin}{Numeric value for minimum value value to be considered in the classifications. dbh values smaller than this will be dismissed from the classification. Default: \code{5}.}
}
\value{
if \code{df} is supplied, a data frame containing the supplied data with a new column for the center of classes; if \code{df} is missing, a vetor with the center of class.
}
\description{
This function can be used to divide the data into classes, based on
minimum value and class interval of a given variable,
and create a column with the center of each class.
}
\examples{
library(forestmangr)
library(dplyr)
data("exfm20")
exfm20

# n
# Number of individuals per ha per diameter class
class_center(df = exfm20, y = "dbh", ci = 10, ymin = 10) 

exfm20 \%>\% 
mutate(CC = class_center(y = dbh, ci = 10, ymin = 10))

}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
