% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graybill_F.R
\name{Graybill_F}
\alias{Graybill_F}
\title{Graybill <i>F</i> Test}
\usage{
Graybill_F(df, Y1, Yj, output = 1, signif = 0.05)
}
\arguments{
\item{df}{A data frame.}

\item{Y1}{Quoted name of the standard variable.}

\item{Yj}{Quoted name of the proposed variable.}

\item{output}{Defines the type of output. If \code{1}, a simple data frame is created, with only essential information about the test. If \code{2}, more information is provided, and if \code{3}, a data frame with informations about the test and both variables is created. Default: \code{1}.}

\item{signif}{Numeric value for the significance level used in the test. Default: \code{0.05}.}
}
\value{
A data frame. It's dimensions will vary, according to the \code{output} argument.
}
\description{
Hypothesis test as described by Graybill (1976).
}
\details{
This test is used to compare two variables, usually a proposed method,
and a standard variable.This test is popular among forestry engineers, 
specially because, since it considers all data in it's analysis, 
it's usually more precise than a standard mean t-test.
If the data has outliers, the mean may not represent the data correctly, so
Graybill <i>F</i> test is specially useful for heterogeneous data.

A simple model regression is applied, and it's significance is evaluated
by applying Graybill <i>F</i> test for the parameters estimate,
according to the methodology described by Graybill (1976).
}
\examples{
library(forestmangr)
data("exfm11")

head(exfm11)

# The data frame exfm11 contains a height variable called "TH". This will be our
# standard value. We'll compare it to height estimated using different hypsometric equations.
# These are variables "TH_EST1" and "TH_EST2":
Graybill_F( exfm11,"TH", "TH_EST1")

# TH_EST1 is statistically different from "TH".

# It's possible to alter the test's significance level using the signif argument:
Graybill_F( exfm11,"TH", "TH_EST1", signif = 0.01)

# Different output options are available through the output argument:
Graybill_F( exfm11,"TH", "TH_EST2", output=2)
Graybill_F( exfm11,"TH", "TH_EST2", output=3)

}
\references{
Campos, J. C. C. and Leite, H. G. (2017) Mensuracao Florestal: Perguntas e Respostas. 5a. Vicosa: UFV.

Graybill, F. A. (1976) Theory and application of the linear model. Massachusets: Ouxburg 239 Press.

Leite, H. G. and Oliveira, F. H. T. (2006) Statistical procedure to test identity between analytical methods, Communications in Soil Science and Plant Analysis, 33(7–8), pp. 1105–1118.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
