% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_country.R
\name{fd_forest_spain_mfe50}
\alias{fd_forest_spain_mfe50}
\title{Download forest cover in Spain}
\usage{
fd_forest_spain_mfe50(province, path_metadata = NULL, quiet = TRUE)
}
\arguments{
\item{province}{A character string of length 1 with the name of a
spanish province}

\item{path_metadata}{A character string of length 1 with the path
to store the metadata of the MFE50. The default
\code{path_metadata = NULL} does not download the
metadata}

\item{quiet}{If \code{TRUE} (the default), suppress status messages, and
the progress bar}
}
\value{
A \code{sf} object with \code{POLYGON} geometry
}
\description{
Download the MFE50 (Spanish Forestry Map 1:50,000) for a province. The
MFE50 was built during 1997-2006.
}
\details{
The Spanish Forestry Map at scale 1:50,000 is a project that was undertaken
during the years 1997-2006. The data contains the cartography of forest
stands in Spain. The definition of the variables is contained in an excel
file that can be downloaded by using the argument \code{path_metadata}.
}
\examples{
\donttest{
# Download MFE50 for the province of Lugo
lugo_mfe50_sf <- fd_forest_spain_mfe50(province = "Lugo")
}
}
\references{
\url{https://www.miteco.gob.es/es/biodiversidad/servicios/banco-datos-naturaleza/informacion-disponible/mfe50.html}
}
\seealso{
[metadata_forestdata] for a list of possible species
}
