% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_country.R
\name{fd_forest_france}
\alias{fd_forest_france}
\title{Download BD Forêt data for a French Department}
\usage{
fd_forest_france(department, path_metadata = NULL, version = 2, quiet = TRUE)
}
\arguments{
\item{department}{A character string of length 1 with the name of a
French department (see examples)}

\item{path_metadata}{A character string of length 1 with the path
to store the metadata of the BD Forêt database.
The default \code{path_metadata = NULL} does
not download the metadata}

\item{version}{The version number of the BD Forêt data. Either 1 or 2 (see details)}

\item{quiet}{If \code{TRUE} (the default), suppress status messages, and
the progress bar}
}
\value{
A \code{sf} object with \code{POLYGON} geometry
}
\description{
Download the BD Forêt data for a French Department. This function downloads
the polygons of forest vegetation in France.
}
\details{
The BD Forêt is a database where the forest cover of France is stored by
department, with the spatial distribution of tree species in the country.

The BD Forêt version 1 was developed by photointerpretation of infrared color
aerial images with a minimum mapped area of 2.25 hectares. The year of reference
for each department varies between 1987 and 2002. The version 1 contains the
following variables:

- DEP: department name

- CYCLE: order number of the departmental revision

- ANREF: year of reference of the data

- TFIFN: code of the departalmenta type of vegetation cover. The nomenclature is
  specific to each department

- LIBELLE: departamental type of vegetation cover. The nomenclature is
  specific to each department

- LIBELLE2: departamental type of vegetation cover in capital letters.
  The nomenclature is specific to each department

- TYPN: code of the national type of vegetation cover

- NOMB_TYPN: national type of vegetation cover

The BD Forêt version 2 was developed between 2007 and 2018 by photointerpretation
of color infrared images from the BD ORTHO. It assigns a vegetation formation
type to each mapped area larger than 5,000\eqn{m^2}. This version contains the variables:

- ID: surface object identifier

- CODE_TFV: alphanumeric code of the vegetation formation

- TFV: vegetation formation type

- TFV_G11: type of coverage and predominant composition of the vegetation
           in 11 groups

- ESSENCE: description of tree species according to the unique basic
           nomenclature for all departments

For more information, download the metadata using the argument
\code{path_metadata} (information in French).
}
\examples{
\donttest{
# Download BD Foret V2 for the department of Ardèche
ardeche_bdforet2_sf <- fd_forest_france(department = "Ardeche") # works (prefered)
ardeche_bdforet2_sf <- fd_forest_france(department = "ardèche") # also works
}
}
\references{
\url{https://geoservices.ign.fr/bdforet}
}
\seealso{
[metadata_forestdata] for a list of possible species
}
