% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection_freqs.R
\name{selection_freqs}
\alias{selection_freqs}
\title{Variable Selection Frequencies}
\usage{
selection_freqs(x)
}
\arguments{
\item{x}{a \code{randomForest} or \code{ranger} object}
}
\value{
\code{data.frame} of variable selection frequencies
}
\description{
Extract variable selection frequencies from \code{randomForest} and \code{ranger} model objects
}
\examples{
library(randomForest)
data(iris)
iris.rf <- randomForest(iris[,-5], iris[,5], forest = TRUE)

iris.freqs <- selection_freqs(iris.rf)
print(iris.freqs)
}
