\name{forega-package}
\alias{forega-package}
\alias{forega}
\docType{package}
\title{
Floating-Point Genetic Algorithms with Statistical Forecast Based Inheritance Operator
}
\description{
forega performs a floating-point genetic algorithm search with a statistical forecasting operator that generates offspring which probably will be generated in future generations. Use of this operator enhances the search capabilities of floating-point genetic algorithms because offspring generated by usual genetic operators rapidly forecasted before performing more generations.
}
\details{
\tabular{ll}{
Package: \tab forega\cr
Type: \tab Package\cr
Version: \tab 1.0.3\cr
Date: \tab 2017-11-23\cr
License: \tab GPL (>= 2)\cr
}

}
\author{
Mehmet Hakan Satman

Maintainer: Mehmet Hakan Satman <mhsatman@istanbul.edu.tr>
}
\references{
A paper about this package is under consideration
}

%\keyword{ package }
%\seealso{}
\examples{

# Required package forega
require("forega")

set.seed(12345)

# This function has the global minimum at x_1 = pi and x_2 = exp(1)
f <- function (x){
	return( (x[1]-pi)^2 + (x[2]-2.71828)^2 )
}

# Performing a floating-point genetic algorithm search with forecast probability of 0.10
res <- forecasting_ga(evalFunc=f, chsize=2, minv=rep(-10.0,2),
                      maxv=rep(10.0,2), crossprob=0.80, mutationprob=0.01, 
                      popsize=100, maxiter=1000, MinimumForecastLength=20, 
                      ForecastFunction=ForecastArima, elitism=2, forecastprob=0.01)

# Show the first chromosome of the returned population matrix
print(res[1,])


}


