% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition-handling.R
\name{warning_flags}
\alias{warning_flags}
\alias{set_warn_on_unknown_function}
\alias{unset_warn_on_unknown_function}
\alias{set_warn_on_local_function}
\alias{unset_warn_on_local_function}
\title{Collection of warning flags used when traversing expressions.}
\usage{
warning_flags()

set_warn_on_unknown_function(flags)

unset_warn_on_unknown_function(flags)

set_warn_on_local_function(flags)

unset_warn_on_local_function(flags)
}
\arguments{
\item{flags}{Used when setting or unsetting flags.}
}
\description{
These are flags for turning warnings on or off when traversing expression
trees.
}
\details{
The flags can be provided to transformation and analysis functions, and be
set or unset by the \code{set_}/\code{unset_} functions. The meaning of the flags are:
\itemize{
\item \strong{warn_on_unknown_function:} If you have installed a callback with
\code{\link[=add_call_callback]{add_call_callback()}} or \code{\link[=add_topdown_callback]{add_topdown_callback()}}, the traversal code will
check if a given call is to a known function installed by one of these. If
the function name of a call is not recognised as a function parameter or a
local variable, as annotated with \code{\link[=annotate_bound_symbols_in_function]{annotate_bound_symbols_in_function()}},
then the code will issue a warning if this flag is set. The warning behaviour
depends on whether \code{\link[=annotate_bound_symbols_in_function]{annotate_bound_symbols_in_function()}} has analysed the
function. If it hasn't, then we only consider function parameters as local
variables. If it has, we have more information about the local variables, so
we can make the warnings more accurate. The flag is set by default.
\item \strong{warn_on_local_function:} If you have installed a callback with
\code{\link[=add_call_callback]{add_call_callback()}} or \code{\link[=add_topdown_callback]{add_topdown_callback()}}, the traversal code will
check if a given call is to a known function installed by one of these. If
you have installed a function that has a name-clash with a local variable,
and this flag is set, then you will get a warning. If you have annotated the
expression tree using \code{\link[=annotate_bound_symbols_in_function]{annotate_bound_symbols_in_function()}}, then the
warning will be invoked both on local variables and function parameters; if
you have not annotated the expression tree, then it will only be invoked on
function arguments. The flag is set by default.
}

Since R is a very dynamic language, it is not possible to know which local
variables might refer to functions and which do not -- and R will look for
functions if a variable is used as a call and potentially skip past a local
variable that refers to a non-function -- so the warnings are based on
heuristics in identifying local variables and are conservative in the sense
that they assume that if a call is to a name that matches a local variable,
then it is the local variable that is being called.
}
\section{Functions}{
\itemize{
\item \code{set_warn_on_unknown_function}: Enable warnings when encountering an unknown
function

\item \code{unset_warn_on_unknown_function}: Disable warnings when encountering an unknown
function

\item \code{set_warn_on_local_function}: Enable warnings when encountering a local variable
with a name that matches one installed for transformation.

\item \code{unset_warn_on_local_function}: Disable warnings when encountering a local variable
with a name that matches one installed for transformation.
}}

