% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{add_topdown_callback}
\alias{add_topdown_callback}
\title{Add a function-specific callback to the top-down callbacks.}
\usage{
add_topdown_callback(callbacks, fn, cb)
}
\arguments{
\item{callbacks}{The existing callbacks.}

\item{fn}{The function to which calls should be modified.}

\item{cb}{The callback function to invoke.}
}
\value{
\preformatted{     The updated callbacks.
}
}
\description{
This function adds to the existing topdown callback, rather than replace it,
by putting a callback in front of it to be tested first. The callback will
be invoked when the traversal sees a call to a specific function.
}
\details{
The callback that is installed will be called with the usual callback
arguments (which depend on context and user-provided information to
..., see \code{\link[=rewrite_callbacks]{rewrite_callbacks()}} and \code{\link[=analysis_callbacks]{analysis_callbacks()}}), and additionally
the next callback in line, through the parameter \code{next_cb}. This can be
used to propagate information through several callbacks in a pipe-like
fashion.
}
