% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_png.R
\name{fa_png}
\alias{fa_png}
\title{Create a PNG version of a Font Awesome icon}
\usage{
fa_png(
  name,
  file = NULL,
  fill = NULL,
  fill_opacity = NULL,
  stroke = NULL,
  stroke_width = NULL,
  stroke_opacity = NULL,
  height = NULL,
  width = NULL
)
}
\arguments{
\item{name}{The name of the Font Awesome icon.}

\item{file}{the path to the output file. If \code{NULL}, then filename will take
the short name of the icon and a \code{.png} extension will be applied.}

\item{fill, fill_opacity}{The fill color of the icon can be set with \code{fill}.
If not provided then the default fill color will be black. The opacity
level of the fill color can be controlled with a decimal value between \code{0}
and \code{1}.}

\item{stroke, stroke_width, stroke_opacity}{The stroke options allow for
setting the color, width, and opacity of the outline stroke. By default,
the stroke width is very small at \code{"1px"} so a size adjustment with
\code{"stroke_width"} can be useful. The \code{"stroke_opacity"} value can be any
decimal values between \code{0} and \code{1} (bounds included).}

\item{height, width}{The output height and width of the rendered PNG. If
nothing is provided then the output dimensions will match that of the input
SVG viewBox.}
}
\value{
A PNG file written to disk.
}
\description{
Get a Font Awesome icon as a PNG file. We can optionally set the fill
attribute before writing the PNG. Additionally, there is control over the
output width and height (usually, icons are 512 by 512 pixels). Please note
that this function requires that the \strong{rsvg} is installed on the system.
Attempting to use \code{fa_png()} without \strong{rsvg} available will result in an
error message.
}
\examples{
if (interactive()) {

# Create a Font Awesome SVG icon as a
# PNG file on disk
fa_png(name = "r-project")

}

}
