% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim.unrestricted}
\alias{sim.unrestricted}
\title{Simulate data from an unrestricted factor model}
\usage{
sim.unrestricted(n, p, q = 2, heavy = FALSE)
}
\arguments{
\item{n}{sample size}

\item{p}{dimension}

\item{q}{number of unrestricted factors}

\item{heavy}{if \code{heavy = FALSE}, common shocks are generated from \code{rnorm} whereas if \code{heavy = TRUE}, from \code{rt} with \code{df = 5} and then scaled by \code{sqrt(3 / 5)}}
}
\value{
a list containing
\item{data}{ generated series}
\item{q}{ number of factors}
}
\description{
Simulate the common component following an unrestricted factor model that does not admit a restricted representation;
see the model (C1) in the reference.
}
\examples{
common <- sim.unrestricted(500, 50)
}
\references{
Barigozzi, M., Cho, H. & Owens, D. (2022) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. arXiv preprint arXiv:2201.06110

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling
}
