% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_2d.R
\name{fm_mesh_2d}
\alias{fm_mesh_2d}
\alias{fm_mesh_2d_inla}
\title{Make a 2D mesh object}
\usage{
fm_mesh_2d(...)

fm_mesh_2d_inla(
  loc = NULL,
  loc.domain = NULL,
  offset = NULL,
  n = NULL,
  boundary = NULL,
  interior = NULL,
  max.edge = NULL,
  min.angle = NULL,
  cutoff = 1e-12,
  max.n.strict = NULL,
  max.n = NULL,
  plot.delay = NULL,
  crs = NULL,
  ...
)
}
\arguments{
\item{...}{Currently passed on to \code{fm_mesh_2d_inla}}

\item{loc}{Matrix of point locations to be used as initial triangulation
nodes.  Can alternatively be a \code{sf}, \code{sfc}, \code{SpatialPoints} or
\code{SpatialPointsDataFrame} object.}

\item{loc.domain}{Matrix of point locations used to determine the domain
extent.  Can alternatively be a \code{SpatialPoints} or
\code{SpatialPointsDataFrame} object.}

\item{offset}{The automatic extension distance.  One or two values, for an
inner and an optional outer extension.  If negative, interpreted as a factor
relative to the approximate data diameter (default=-0.10???)}

\item{n}{The number of initial nodes in the automatic extensions
(default=16)}

\item{boundary}{one or more (as list) of \code{\link[=fm_segm]{fm_segm()}} objects, or objects
supported by \code{\link[=fm_as_segm]{fm_as_segm()}}}

\item{interior}{one object supported by \code{\link[=fm_as_segm]{fm_as_segm()}}, or (from version
\verb{0.2.0.9016}) a list of such objects.  If a list, the objects are joined
into a single object.}

\item{max.edge}{The largest allowed triangle edge length.  One or two
values.}

\item{min.angle}{The smallest allowed triangle angle.  One or two values.
(Default=21)}

\item{cutoff}{The minimum allowed distance between points.  Point at most as
far apart as this are replaced by a single vertex prior to the mesh
refinement step.}

\item{max.n.strict}{The maximum number of vertices allowed, overriding
\code{min.angle} and \code{max.edge} (default=-1, meaning no limit).  One or
two values, where the second value gives the number of additional vertices
allowed for the extension.}

\item{max.n}{The maximum number of vertices allowed, overriding
\code{max.edge} only (default=-1, meaning no limit).  One or two values,
where the second value gives the number of additional vertices allowed for
the extension.}

\item{plot.delay}{If logical \code{TRUE} or a negative numeric value,
activates displaying the
result after each step of the multi-step domain extension algorithm.}

\item{crs}{An optional \code{\link[=fm_crs]{fm_crs()}}, \code{sf::crs} or \code{sp::CRS} object}
}
\value{
An \code{fm_mesh_2d} object.
}
\description{
Make a 2D mesh object
}
\section{Functions}{
\itemize{
\item \code{fm_mesh_2d_inla()}: Legacy method for \code{INLA::inla.mesh.2d()}
Create a triangle mesh based on initial point locations, specified or
automatic boundaries, and mesh quality parameters.

}}
\section{INLA compatibility}{

For mesh and curve creation, the \code{\link[=fm_rcdt_2d_inla]{fm_rcdt_2d_inla()}}, \code{\link[=fm_mesh_2d_inla]{fm_mesh_2d_inla()}},
and \code{\link[=fm_nonconvex_hull_inla]{fm_nonconvex_hull_inla()}} methods will keep the interface syntax used by
\code{INLA::inla.mesh.create()}, \code{INLA::inla.mesh.2d()}, and
\code{INLA::inla.nonconvex.hull()} functions, respectively, whereas the
\code{\link[=fm_rcdt_2d]{fm_rcdt_2d()}}, \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, and \code{\link[=fm_nonconvex_hull]{fm_nonconvex_hull()}} interfaces may be
different, and potentially change in the future.
}

\examples{
fm_mesh_2d_inla(boundary = fm_extensions(cbind(2, 1), convex = 1, 2))

}
\seealso{
\code{\link[=fm_rcdt_2d]{fm_rcdt_2d()}}, \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, \code{\link[=fm_delaunay_2d]{fm_delaunay_2d()}},
\code{\link[=fm_nonconvex_hull]{fm_nonconvex_hull()}}, \code{\link[=fm_extensions]{fm_extensions()}}, \code{\link[=fm_refine]{fm_refine()}}

Other object creation and conversion: 
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{object creation and conversion}
