% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{call-stack}
\alias{call-stack}
\alias{fm_caller_name}
\alias{fm_call_stack}
\alias{fm_try_callstack}
\title{Call stack utility functions}
\usage{
fm_caller_name(which = 0L, override = NULL)

fm_call_stack(start = 0L, end = 0L, with_numbers = TRUE, ...)

fm_try_callstack(expr)
}
\arguments{
\item{which}{The number of frames to go back from the caller}

\item{override}{character; Overrides the automated function name logic}

\item{start}{The stack starting point}

\item{end}{The stack end point}

\item{with_numbers}{INclude call stack location numbers}

\item{\dots}{Currently unused}

\item{expr}{An \code{expression} to evaluate}
}
\value{
\code{fm_caller_name} returns a string with the the name of a calling function

\code{fm_call_stack} returns a character vector

\code{fm_try_callstack} If successful, returns (invisibly) the value from the
evaluated expression, otherwise an error object with call stack information attached
to the error message.
}
\description{
Helper functions for displaying call stack information
}
\section{Functions}{
\itemize{
\item \code{fm_call_stack()}: 

\item \code{fm_try_callstack()}: Inspired by \code{berryFunctions::tryStack}

}}
\examples{
fun <- function() {
  print(fm_caller_name())
  nm <- fm_caller_name()
  print(nm)
}
fun()
}
\keyword{internal}
