% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to-flowmat.R
\name{to_flowmat}
\alias{as.flowmat}
\alias{is.flowmat}
\alias{to_flowmat}
\alias{to_flowmat.data.frame}
\alias{to_flowmat.flow}
\alias{to_flowmat.list}
\title{Create a flowmat using a list a commands.}
\usage{
to_flowmat(x, ...)

\method{to_flowmat}{list}(x, samplename, ...)

\method{to_flowmat}{data.frame}(x, ...)

\method{to_flowmat}{flow}(x, ...)

as.flowmat(x, grp_col, jobname_col, cmd_col, ...)

is.flowmat(x)
}
\arguments{
\item{x}{a named list, where name corresponds to the jobname and value is a vector of commands to run.}

\item{...}{not used}

\item{samplename}{character of length 1 or that of nrow(x) ['samplename']}

\item{grp_col}{column used for grouping, default samplename.}

\item{jobname_col}{column specifying jobname, default jobname}

\item{cmd_col}{column specifying commands to run, default cmd}
}
\description{
Create a flowmat (data.frame) using a \strong{named} list a commands.

as.flowmat(): reads a file and checks for required columns. If x is data.frame checks for required columns.
}
\examples{

# Use this link for a few examples:
# http://docs.flowr.space/tutorial.html#define_modules

# create a flow mat, starting with a list of commands.
cmd_sleep = c("sleep 1", "sleep 2")
cmd_echo = c("echo 'hello'", "echo 'hello'")

# create a named list
lst = list("sleep" = cmd_sleep, "echo" = cmd_echo)
flowmat = to_flowmat(lst, samplename = "samp")



# read in a tsv; check and confirm format
ex = file.path(system.file(package = "flowr"), "pipelines")

flowmat = as.flowmat(file.path(ex, "sleep_pipe.tsv"))

# if your column names are different than defaults, explicitly specify them.
flowmat = as.flowmat(file.path(ex, "sleep_pipe.tsv"), jobname_col = "jobname")

# check if a object is a flowmat
is.flowmat(flowmat)



# create a flowdef, from this flowmat
flowdef = to_flowdef(flowmat)

# create a flow object using flowmat and flowdef
fobj = to_flow(flowmat, flowdef)

# extract a flowmat from a flow (here the samplename also contains the name of the flow)
flowmat2 = to_flowmat(fobj)



## submit the flow to the cluster (execute=TRUE) or do a dry-run (execute=FALSE)
\dontrun{
fobj2 = submit_flow(fobj, execute=FALSE)
fobj3 = submit_flow(fobj, execute=TRUE)

## Get the status or kill all the jobs
status(fobj3)
kill(fobj3)
}



}

