% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/submit-flow.R
\name{submit_flow}
\alias{submit_flow}
\alias{submit_flow.flow}
\alias{submit_flow.list}
\title{Submit a flow to the cluster}
\usage{
submit_flow(x, verbose = get_opts("verbose"), ...)

\method{submit_flow}{list}(x, verbose = get_opts("verbose"), ...)

\method{submit_flow}{flow}(x, verbose = get_opts("verbose"),
  execute = FALSE, uuid, plot = TRUE, dump = TRUE, .start_jid = 1, ...)
}
\arguments{
\item{x}{a \code{object} of class \code{flow}.}

\item{verbose}{logical.}

\item{...}{Advanced use. Any additional parameters are passed on to \link{submit_job} function.}

\item{execute}{\code{logical} whether or not to submit the jobs}

\item{uuid}{\code{character} Advanced use. This is the final path used for flow execution.
Especially useful in case of re-running a flow.}

\item{plot}{\code{logical} whether to make a pdf flow plot (saves it in the flow working directory).}

\item{dump}{dump all the flow details to the flow path}

\item{.start_jid}{Job to start this submission from. Advanced use, should be 1 by default.}
}
\description{
Submit a flow to the cluster or perform a dry-run to check and debug issues.
}
\details{
NOTE:
Even if you want to kill the flow, its best to let submit_flow do its job, when done simply use \code{kill(flow_wd)}.
If submit_flow is interrupted, files like flow_details.rds etc are not created, thus flowr looses the association
of jobs with flow instance and cannot monitor, kill or re-run the flow.
}
\examples{
\dontrun{
submit_flow(fobj = fobj, ... = ...)}
}

