% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-units.R
\name{classify_units}
\alias{classify_units}
\title{Create the DEGURBA spatial units classification}
\usage{
classify_units(
  data,
  id = "UID",
  level1 = TRUE,
  values = NULL,
  official_workflow = TRUE,
  filename = NULL
)
}
\arguments{
\item{data}{named list with the required data, as returned by the function \code{\link[=DoU_preprocess_units]{DoU_preprocess_units()}}}

\item{id}{character. Unique column in the \code{units} data as id for spatial units}

\item{level1}{logical. Whether to classify the spatial units according to first hierarchical level (\code{TRUE}) or the second hierarchical level (\code{FALSE}). For more details, see section "Classification rules" below.}

\item{values}{vector with the values assigned to the different classes in the resulting units classification:
\itemize{
\item If \code{level1=TRUE}: the vector should contain the values for (1) cities, (2) town and semi-dense areas and (3) rural areas.
\item If \code{level1=FALSE}: the vector should contain the values for (1) cities, (2) dense towns, (3) semi-dense towns, (4) suburb or peri-urban areas, (5) villages, (6) dispersed rural areas and (7) mostly uninhabited areas.
}}

\item{official_workflow}{logical. Whether to employ the official workflow of the GHSL (\code{TRUE}) or the alternative workflow (\code{FALSE}). For more details, see section "Workflow" below.}

\item{filename}{character. Output filename (csv). The resulting classification together with a metadata file (in JSON format) will be saved if \code{filename} is not \code{NULL}.}
}
\value{
dataframe with for each spatial unit the classification and the share of population per grid class
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{classify_units()} has been renamed to \code{DoU_classify_units()} to create a more consistent API and to better indicate that this function is specifically designed to classify units in the context of the DEGURBA classification`.
}
\keyword{internal}
