% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{colorize}
\alias{colorize}
\title{Colorize chunk}
\usage{
colorize(x, color)
}
\arguments{
\item{x}{value, if a chunk, the chunk will be updated}

\item{color}{color to use as text highlighting color as character vector.}
}
\description{
The function is producing a chunk with
a font in color.

It is used to add it to the content of a cell of the
flextable with the functions \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}
or \code{\link[=prepend_chunks]{prepend_chunks()}}.
}
\examples{
ft <- flextable(head(iris),
  col_keys = c("Sepal.Length", "dummy")
)

ft <- compose(ft,
  j = "dummy",
  value = as_paragraph(colorize(Sepal.Length, color = "red"))
)

ft
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_b}()},
\code{\link{as_bracket}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_i}()},
\code{\link{as_image}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
