% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{hrule}
\alias{hrule}
\title{Set flextable rule for rows heights}
\usage{
hrule(x, i = NULL, rule = "auto", part = "body")
}
\arguments{
\item{x}{flextable object}

\item{i}{rows selection}

\item{rule}{specify the meaning of the height. Possible values
are "atleast" (height should be at least the value specified), "exact"
(height should be exactly the value specified), or the default value "auto"
(height is determined based on the height of the contents, so the value is ignored).}

\item{part}{partname of the table, one of "all", "header", "body", "footer"}
}
\description{
control rules of each height for a part
of the flextable, this is only for Word and PowerPoint outputs, it
will not have any effect when output is HTML or PDF.

For PDF see the \code{ft.arraystretch} chunk option.
}
\examples{

ft_1 <- flextable(head(iris))
ft_1 <- width(ft_1, width = 1.5)
ft_1 <- height(ft_1, height = 0.75, part = "header")
ft_1 <- hrule(ft_1, rule = "exact", part = "header")
ft_1

ft_2 <- hrule(ft_1, rule = "auto", part = "header")
ft_2
}
\seealso{
Other flextable dimensions: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{set_table_properties}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
