% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_chunk}
\alias{as_chunk}
\title{Chunk of text wrapper}
\usage{
as_chunk(x, props = NULL, formatter = format_fun, ...)
}
\arguments{
\item{x}{text or any element that can be formatted as text
with function provided in argument \code{formatter}.}

\item{props}{an \code{\link[=fp_text_default]{fp_text_default()}} or \code{\link[officer:fp_text]{officer::fp_text()}} object to be used to format the text.
If not specified, it will be the default value corresponding to the cell.}

\item{formatter}{a function that will format x as a character vector.}

\item{...}{additional arguments for \code{formatter} function.}
}
\description{
The function lets add formated text in flextable
cells.

It is used to add it to the content of a cell of the
flextable with the functions \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}
or \code{\link[=prepend_chunks]{prepend_chunks()}}.

It should be used inside a call to \code{\link[=as_paragraph]{as_paragraph()}}.
}
\examples{
library(officer)

ft <- flextable( head(iris))

ft <- compose( ft, j = "Sepal.Length",
 value = as_paragraph(
   "Sepal.Length value is ",
   as_chunk(Sepal.Length, props = fp_text(color = "red"))
 ),
 part = "body")
ft <- color(ft, color = "gray40", part = "all")
ft <- autofit(ft)
ft
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
