% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{hyperlink_text}
\alias{hyperlink_text}
\title{chunk of text with hyperlink wrapper}
\usage{
hyperlink_text(x, props = NULL, formater = format_fun, url, ...)
}
\arguments{
\item{x}{text or any element that can be formatted as text
with function provided in argument \code{formater}.}

\item{props}{an \code{\link[officer]{fp_text}} object to be used to format the text.
If not specified, it will be the default value corresponding to the cell.}

\item{formater}{a function that will format x as a character vector.}

\item{url}{url to be used}

\item{...}{additional arguments for \code{formater} function.}
}
\description{
The function lets add hyperlinks within flextable
objects with function \code{\link{compose}}.
It should be used inside a call to \code{\link{as_paragraph}}.
}
\examples{
dat <- data.frame(
  col = "Google it",
  href = "https://www.google.fr/search?source=hp&q=flextable+R+package",
  stringsAsFactors = FALSE)

ft <- flextable(dat)
ft <- compose( x = ft, j = "col",
  value = as_paragraph(
    "This is a link: ",
    hyperlink_text(x = col, url = href ) ) )
ft
}
\seealso{
\code{\link{display}}

Other chunk elements for paragraph: \code{\link{as_bracket}},
  \code{\link{as_b}}, \code{\link{as_chunk}},
  \code{\link{as_image}}, \code{\link{as_i}},
  \code{\link{as_sub}}, \code{\link{as_sup}},
  \code{\link{linerange}}, \code{\link{minibar}}
}
\concept{chunk elements for paragraph}
