% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_flexsurvreg.R
\name{simulate.flexsurvreg}
\alias{simulate.flexsurvreg}
\title{Simulate datasets from a fitted flexsurvreg model}
\usage{
\method{simulate}{flexsurvreg}(
  object,
  nsim = 1,
  seed = NULL,
  censtime = NULL,
  vectorised = TRUE,
  ...
)
}
\arguments{
\item{object}{Object returned by flexsurvreg}

\item{nsim}{Number of datasets to simulate}

\item{seed}{Random number seed. This is returned with the result of this
function as described in \code{\link{simulate}}.}

\item{censtime}{Right-censoring time, or vector of right-censoring times of
the same size as the data used to fit the model.}

\item{vectorised}{Set to \code{FALSE} if the fitted model uses distribution
functions from a package other than \pkg{flexsurv} and those functions are
not vectorised.  By default, this function assumes that they are
vectorised. Incomprehensible warnings may be printed and the simulation is
not guaranteed to work if this assumption is wrong.  Vectorising will 
generally make the simulation much faster.}

\item{...}{Currently unused.}
}
\value{
A data frame with \code{nsim} pairs of columns named
  \code{"sim_1","event_1"} and so on, containing the simulated event or
  censoring times, and an indicator for whether the event was observed.
}
\description{
Simulate datasets from a fitted flexsurvreg model
}
