% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ajfit.R
\name{ajfit_fmsm}
\alias{ajfit_fmsm}
\title{Check the fit of Markov flexible parametric multi-state models against
nonparametric estimates.}
\usage{
ajfit_fmsm(x, maxt = NULL, newdata = NULL)
}
\arguments{
\item{x}{Object returned by \code{\link{fmsm}} representing a flexible
parametric multi-state model.  This must be Markov, rather than
semi-Markov, and no check is performed for this.   Note that all
"competing risks" style models, with just one source state and multiple
destination states, are Markov, so those are fine here.}

\item{maxt}{Maximum time to compute parametric estimates to.}

\item{newdata}{Data frame defining the subgroups to consider.  This must
have a column for each covariate in the model.  If omitted, then all
potential subgroups defined by combinations of factor covariates are
included.  Continuous covariates are not supported.}
}
\value{
Tidy data frame containing both Aalen-Johansen and parametric
  estimates of state occupancy over time, and by subgroup if subgroups are
  included.
}
\description{
Computes both parametric and comparable Aalen-Johansen nonparametric
estimates from a flexible paramrtric multi-state model, and returns them
together in a tidy data frame.  Only models w ith no covariates, or only
factor covariates, are supported.  If there are factor covariates, then the
nonparametric estimates are computed for subgroups defined by combinations
of the covariates.
}
