% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarkers.R
\docType{data}
\name{biomarkers}
\alias{biomarkers}
\title{Example biomarker data}
\format{
\code{biomarkers}: a tibble with 306 rows and 24 columns, where the first
column is the validation site, the next two columns are the possible outcomes,
and the remaining columns are the biomarkers:
\describe{
\item{institution}{the validation site}
\item{mucinous}{a binary indicator of whether the cyst was classified as mucinous}
\item{high_malignancy}{a binary indicator of whether the cyst was classified as having high malignant potential}
\item{lab1_actb}{a biomarker}
\item{lab1_molecules_score}{a biomarker}
\item{lab1_telomerase_score}{a biomarker}
\item{lab2_fluorescence_score}{a biomarker}
\item{lab3_muc3ac_score}{a biomarker}
\item{lab3_muc5ac_score}{a biomarker}
\item{lab4_areg_score}{a biomarker}
\item{lab4_glucose_score}{a biomarker}
\item{lab5_mucinous_call}{a biomarker (binary)}
\item{lab5_neoplasia_v1_call}{a biomarker (binary)}
\item{lab5_neoplasia_v2_call}{a biomarker (binary)}
\item{lab6_ab_score}{a biomarker}
\item{cea}{a biomarker}
\item{lab1_molecules_neoplasia_call}{binary indicator of whether \code{lab1_molecules_score} > 25}
\item{lab1_telomerase_neoplasia_call}{binary indicator of whether \code{lab1_telomerase_score} > 730}
\item{lab2_fluorescence_mucinous_call}{binary indicator of whether \code{lab2_fluorescence_score} > 1.23}
\item{lab4_areg_mucinous_call}{binary indicator of whether \code{lab4_areg_score} > 112}
\item{lab4_glucose_mucinous_call}{binary indicator of whether \code{lab4_glucose_score} < 50}
\item{lab4_combined_mucinous_call}{binary indicator of whether \code{lab4_areg_score} > 112 and \code{lab4_glucose_score} < 50}
\item{lab6_ab_neoplasia_call}{binary indicator of whether \code{lab6_ab_score} > 0.104}
\item{cea_call}{binary indicator of whether \code{cea} > 192}
}
}
\source{
Inspired by data collected by the EDRN \url{https://edrn.nci.nih.gov/}.
}
\usage{
biomarkers
}
\description{
A dataset inspired by data collected by the Early Detection Research
Network (EDRN). Biomarkers developed at six "labs" are validated at
at least one of four "validation sites" on 306 cysts. The data also include two binary outcome variables: whether or not the cyst was classified as mucinous,
and whether or not the cyst was determined to have high malignant potential.
}
\keyword{datasets}
