% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getAttribute}
\alias{fxml_getAttribute}
\title{Attributes of an XML element}
\usage{
fxml_getAttribute(xmlflat.df, elemid, attrib.name)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}

\item{attrib.name}{Name of the attribute.}
}
\value{
The value of attribute \code{attrib.name} of the XML element with ID \code{elemid}. If the attribute is not existing, an error message is shown.
}
\description{
Returns the value of a specific attribute of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Read the value of attribute "name" from the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_getAttribute(xml.dataframe, 4, "name")
}
\seealso{
\code{\link{fxml_hasAttributes}}, \code{\link{fxml_numAttributes}}, \code{\link{fxml_getAttributesAll}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
