% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel_file.R
\name{read_excel_file}
\alias{read_excel_file}
\title{Import Excel file}
\usage{
read_excel_file(
  file,
  sheetIndexes = c(),
  sheetNames = c(),
  encoding = "UTF-8",
  password = NULL
)
}
\arguments{
\item{file}{A string, name of an Excel file.}

\item{sheetIndexes}{A vector of numbers, sheet indexes in the workbook.}

\item{sheetNames}{A vector of strings, sheet names.}

\item{encoding}{A string, encoding to be assumed for input strings.}

\item{password}{A string with the password (if required).}
}
\value{
A \code{pivot_table} object list.
}
\description{
Reads sheets from an Excel file and creates a \code{pivot_table} object list, one
from each sheet. Each sheet is expected to contain a pivot table. Each line
in a sheet corresponds to a row in a table. The file and sheet names are
included as part of each object attributes.
}
\details{
When multiple files or sheets are handled, the file and/or sheet names may
contain information associated with the pivot table, they could be the table
page information. In order not to lose this information, they are always
stored in each \code{pivot_table} object.
}
\examples{
file <- system.file("extdata", "excel/set_sheets.xlsx", package = "flattabler")
# lpt <- read_excel_file(file)

# lpt <- read_excel_file(file, sheetIndexes = 1:4)

# lpt <- read_excel_file(file, sheetNames = c("M1", "M2", "M3", "M4"))

}
\seealso{


Other import functions: 
\code{\link{pivot_table}()},
\code{\link{read_excel_folder}()},
\code{\link{read_excel_sheet}()},
\code{\link{read_text_file}()},
\code{\link{read_text_folder}()}
}
\concept{import functions}
