% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_seq2seq_decoder.R
\name{LexiconSeq2SeqDecoder}
\alias{LexiconSeq2SeqDecoder}
\title{LexiconSeq2SeqDecoder}
\description{
Decoder implements a beam seach decoder that finds the token transcription.
W maximizing:
}
\details{
AM(W) + lmWeight_ * log(P_{lm}(W)) + eosScore_ * |W_last == EOS|

where P_{lm}(W) is the language model score. The transcription W is 
constrained by a lexicon. The language model may operate at word-level 
(isLmToken = FALSE) or token-level (isLmToken = TRUE).
}
\section{Super class}{
\code{\link[flashlighttext:Decoder]{flashlighttext::Decoder}} -> \code{LexiconSeq2SeqDecoder}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LexiconSeq2SeqDecoder-new}{\code{LexiconSeq2SeqDecoder$new()}}
\item \href{#method-LexiconSeq2SeqDecoder-n_hypothesis}{\code{LexiconSeq2SeqDecoder$n_hypothesis()}}
\item \href{#method-LexiconSeq2SeqDecoder-clone}{\code{LexiconSeq2SeqDecoder$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="decode"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-decode'><code>flashlighttext::Decoder$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="get_all_final_hypothesis"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-get_all_final_hypothesis'><code>flashlighttext::Decoder$get_all_final_hypothesis()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="get_best_hypothesis"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-get_best_hypothesis'><code>flashlighttext::Decoder$get_best_hypothesis()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="n_decoded_frames_in_buffer"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-n_decoded_frames_in_buffer'><code>flashlighttext::Decoder$n_decoded_frames_in_buffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="prune"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-prune'><code>flashlighttext::Decoder$prune()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconSeq2SeqDecoder-new"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconSeq2SeqDecoder-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconSeq2SeqDecoder$new(
  options,
  trie,
  lm,
  eos,
  emitting_model_update_func,
  max_output_length,
  is_lm_token
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{options}}{a LexiconSeq2SeqDecoderOptions instance.}

\item{\code{trie}}{a Trie instance}

\item{\code{lm}}{a LM instance}

\item{\code{eos}}{an integer. The index representing the EOS.}

\item{\code{emitting_model_update_func}}{an emittingModelUpdateFunc instance}

\item{\code{max_output_length}}{an integer. The maximum output length.}

\item{\code{is_lm_token}}{a is_lm_token}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
LexiconSeq2SeqDecoder
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconSeq2SeqDecoder-n_hypothesis"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconSeq2SeqDecoder-n_hypothesis}{}}}
\subsection{Method \code{n_hypothesis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconSeq2SeqDecoder$n_hypothesis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
int
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconSeq2SeqDecoder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconSeq2SeqDecoder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconSeq2SeqDecoder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
