% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_performance.R
\name{light_performance}
\alias{light_performance}
\alias{light_performance.default}
\alias{light_performance.flashlight}
\alias{light_performance.multiflashlight}
\title{Model Performance of Flashlight}
\usage{
light_performance(x, ...)

\method{light_performance}{default}(x, ...)

\method{light_performance}{flashlight}(
  x,
  data = x$data,
  by = x$by,
  metrics = x$metrics,
  use_linkinv = FALSE,
  metric_name = "metric",
  value_name = "value",
  label_name = "label",
  ...
)

\method{light_performance}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Arguments passed from or to other functions.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results. Will overwrite \code{x$by}.}

\item{metrics}{An optional named list with metrics. Each metric takes at least four arguments: actual, predicted, case weights w and \code{...}.}

\item{use_linkinv}{Should retransformation function be applied? Default is FALSE.}

\item{metric_name}{Column name in resulting \code{data} containing the name of the metric. Defaults to "metric".}

\item{value_name}{Column name in resulting \code{data} containing the value of the metric. Defaults to "value".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}
}
\value{
An object of class \code{light_performance}, \code{light} (and a list) with the following elements.
\itemize{
\item \code{data} A tibble containing the results. Can be used to build fully customized visualizations.
\item \code{by} Same as input \code{by}.
\item \code{metric_name} Same as input \code{metric_name}.
\item \code{value_name} Same as input \code{value_name}.
\item \code{label_name} Same as input \code{label_name}.
}
}
\description{
Calculates performance of a flashlight with respect to one or more performance measure.
}
\details{
The minimal required elements in the (multi-) flashlight are "y", "predict_function", "model", "data" and "metrics". The latter two can also directly be passed to \code{light_performance}. Note that by default, no retransformation function is applied.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Model performance of flashlight object.

\item \code{multiflashlight}: Model performance of multiflashlight object.
}}

\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
fl <- flashlight(model = fit, label = "lm", data = iris, y = "Sepal.Length")
light_performance(fl)
light_performance(fl, by = "Species")
}
\seealso{
\code{\link{plot.light_performance}}.
}
