% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMixRHLP.R
\docType{class}
\name{ModelMixRHLP-class}
\alias{ModelMixRHLP-class}
\alias{ModelMixRHLP}
\title{A Reference Class which represents a fitted mixture of RHLP model.}
\description{
ModelMixRHLP represents an estimated mixture of RHLP model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamMixRHLP} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatMixRHLP} object. It contains all the
statistics associated to the MixRHLP model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("estimatedsignal", "regressors", "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"estimatedsignal" = } Estimated signal (field
        \code{Ey} of class \link{StatMixRHLP}).
      \item \code{"regressors" = } Polynomial regression components
        (fields \code{polynomials} and \code{pi_jkr} of class
        \link{StatMixRHLP}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatMixRHLP}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the above graphs are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(toydataset)

# Let's fit a mixRHLP model on a dataset containing 2 clusters:
data <- toydataset[1:190,1:21]
x <- data$x
Y <- t(data[,2:ncol(data)])

mixrhlp <- cemMixRHLP(X = x, Y = Y, K = 2, R = 2, p = 1, verbose = TRUE)

# mixrhlp is a ModelMixRHLP object. It contains some methods such as 'summary' and 'plot'
mixrhlp$summary()
mixrhlp$plot()

# mixrhlp has also two fields, stat and param which are reference classes as well

# Log-likelihood:
mixrhlp$stat$loglik

# Parameters of the polynomial regressions:
mixrhlp$param$beta
}
\seealso{
\link{ParamMixRHLP}, \link{StatMixRHLP}
}
