% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{print.fixest_multi}
\alias{print.fixest_multi}
\title{Print method for fixest_multi objects}
\usage{
\method{print}{fixest_multi}(x, ...)
}
\arguments{
\item{x}{A \code{fixest_multi} object, obtained from a \code{fixest} estimation leading to
multiple results.}

\item{...}{Other arguments to be passed to \code{\link{summary.fixest_multi}}.}
}
\description{
Displays summary information on fixest_multi objects in the R console.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

# Multiple estimation
res = feols(y ~ csw(x1, x2, x3), base, split = ~species)

# Let's print all that
res

}
\seealso{
The main fixest estimation functions: \code{\link{feols}}, \code{\link[=feglm]{fepois}},
\code{\link[=femlm]{fenegbin}}, \code{\link{feglm}}, \code{\link{feNmlm}}. Tools for mutliple fixest
estimations: \code{\link{summary.fixest_multi}}, \code{\link{print.fixest_multi}}, \code{\link{as.list.fixest_multi}},
\code{\link[fixest]{sub-sub-.fixest_multi}}, \code{\link[fixest]{sub-.fixest_multi}}.
}
