% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nfl_fandom_google}
\alias{nfl_fandom_google}
\title{How Every NFL Team’s Fans Lean Politically}
\format{
a data frame with 207 rows representing designated market areas and 9 variables:
\describe{
\item{dma}{Designated Market Area}
\item{nfl}{The percentage of search traffic in the media market region related to the NFL over the past 5 years}
\item{nba}{The percentage of search traffic in the region related to the NBA over the past 5 years}
\item{mlb}{The percentage of search traffic in the region related to the MLB over the past 5 years}
\item{nascar}{The percentage of search traffic in the region related to NASCAR over the past 5 years}
\item{cbb}{The percentage of search traffic in the region related to the CBB over the past 5 years}
\item{cfb}{The percentage of search traffic in the region related to the CFB over the past 5 years}
\item{trump_2016_vote}{The percentage of voters in the region who voted for Trump in the 2016 Presidential Election}
}
}
\source{
Google Trends \url{https://trends.google.com/}.
}
\usage{
nfl_fandom_google
}
\description{
The raw data behind the story
"How Every NFL Team’s Fans Lean Politically"
\url{https://fivethirtyeight.com/features/how-every-nfl-teams-fans-lean-politically}: Google Trends Data.
}
\examples{
# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
nfl_fandom_google_tidy <- nfl_fandom_google \%>\%
  pivot_longer(-c("dma", "trump_2016_vote"), 
    names_to = "sport", values_to = "search_traffic") \%>\%
  arrange(dma)
}
\seealso{
\code{\link{nfl_fandom_surveymonkey}}
}
\keyword{datasets}
