% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_ladder.R
\name{return_ladder}
\alias{return_ladder}
\title{Recreate the ladder for every or any given round and/or season}
\usage{
return_ladder(match_results_df = NA, season_round = NA, season = NA)
}
\arguments{
\item{match_results_df}{A dataframe that has been returned from get_match_results. If empty \code{get_match_results} will execute first}

\item{season_round}{An integer of the round or vector of integers for multiple rounds. If empty, all rounds returned}

\item{season}{An integer of the season or vector of integers for multiple seasons. If empty, all seasons returned}
}
\value{
Returns a data frame containing a line for each team's ladder position at each round of a season
}
\description{
\code{return_ladder} returns a dataframe containing the ladder for either all seasons and rounds since 1987, or individual rounds/seasons
}
\details{
The dataframe contains information about the Round, Season, Points For/Against, Ladder Position. It can either take in a data frame created using \code{get_match_results}, or if \code{match_results_df} is unspecified, will extract all games using \code{get_match_results}.
Will only allow selecting rounds of the premiership season, not finals.
}
\examples{
\dontrun{
return_ladder()
return_ladder(match_results_df=get_match_results_df, season_round=23, season=1990:2019)
return_ladder(season_round = 10, season = 2019)
}
}
