% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afltables_player_main.R
\name{scrape_afltables_match}
\alias{scrape_afltables_match}
\title{Return afltables player match stats}
\usage{
scrape_afltables_match(match_urls)
}
\arguments{
\item{match_urls}{A list of URL's for matches to scrape data from}
}
\value{
data table of afltables.com match results, with a row per player per match.
}
\description{
\code{scrape_afltables_match} returns a character vector containing match URLs for the specified date range
}
\details{
This function returns the full afltables.com match stats for each player and each game specified in \code{match_urls}.
It is useful to use the helper function \code{get_afltables_urls} to return these or simply navigate to afltables.com
and find the match of interest.
}
\examples{
\donttest{
scrape_afltables_match("https://afltables.com/afl/stats/games/2018/071120180602.html")
scrape_afltables_match(get_afltables_urls("01/06/2018", "01/07/2018"))
}
}
