Psurveys = list(
  coulson = makeData(n = 0,
                     count = 120,
                     type = "P",
                     notes = bibentry(bibtype = "Article",
                                      title = "Glass on clothing and shoes of members of the general population and people suspected of breaking crimes",
                                      journal = "Science & Justice",
                                      volume = "41",
                                      number = "1",
                                      pages = "39--48",
                                      year = "20011",
                                      doi = "https://doi.org/10.1016/S1355-0306(01)71847-3",
                                      author = c(
                                        person("S. A.", "Coulson"),
                                        person("J. S.", "Buckleton"),
                                        person("A. B.", "Gummer"),
                                        person("C. M.", "Triggs")
                                       )
                     )),
  jackson = makeData(n = 0:1,
                     count = c(224, 6),
                     type = "P",
                     notes = bibentry(bibtype = "Article",
                                      title = "A survey of glass found on the headwear and head hair of a random population vs. people working with glass",
                                      journal = "Forensic Science International",
                                      volume = "226",
                                      number = "1",
                                      pages = "125--131",
                                      year = "2013",
                                      doi = "https://doi.org/10.1016/j.forsciint.2012.12.017",
                                      author = c(
                                        person("F.", "Jackson"),
                                        person("P.", "Maynard"),
                                        person("K.", "Cavanagh-Steer"),
                                        person("T.", "Dusting"),
                                        person("C.", "Roux")
                                      )
                       )),
  lau = makeData(n = 0:1,
               count = c(211, 2),
               type = "P",
               notes = bibentry(bibtype = "Article",
                                author = c(as.person("L. Lau"),
                                           as.person("A. D. Beveridge"),
                                           as.person("B. C. Callowhill"),
                                           as.person("N. Conners"),
                                           as.person("K. Foster"),
                                           as.person("R. J. Groves"),
                                           as.person("K. N. Ohashi"),
                                           as.person("A. M. Sumner"),
                                           as.person("H. Wong")
                                           ),
                                title = "The Frequency of Occurrence of Paint and Glass on the Clothing of High School Students",
                                journal = "Canadian Society of Forensic Science Journal",
                                volume = "30",
                                number = "4",
                                pages = "233-240",
                                year  = "1997",
                                doi = "10.1080/00085030.1997.10757103"
               )),
  pettard = makeData(n = 0:1,
                     count = c(2002, 6),
                     type = "P",
                     notes = bibentry(bibtype = "InProceedings",
                                     author = c(person(given = "C. I.", family = "Petterd"),
                                                person(given = "I.", family = "McCallum"),
                                                person(given = "L.", family = "Bradford"),
                                                person(given = "K.", family = "Brinch"),
                                                person(given = "S.", family = "Stewart")
                                                ),
                                      year = "1998",
                                      title = "Glass particles in the clothing of the general population in Canberra---a survey",
                                      booktitle = "Proceedings of the 14th International Symposium on the Forensic Sciences",
                                      date = "12--16 October 1998",
                                      city = "Adelaide, South Australia",
                                      publisher = "Australian and New Zealand Forensic Science Society"
              )),
  ross = makeData(n = 0:1,
                  count = c(85,2),
                  type = "P",
                  notes = bibentry(bibtype = "InProceedings",
                                   author = c(person(given = "P.", family = "Ross"),
                                              person(given = "H.", family = "Nguyen")
                                   ),
                                   year = "1998",
                                   title = "A survey of clothing for the presence of glass fragments",
                                   booktitle = "Proceedings of the 14th International Symposium on the Forensic Sciences",
                                   date = "12--16 October 1998",
                                   city = "Adelaide, South Australia",
                                   publisher = "Australian and New Zealand Forensic Science Society"
              )),
   roux = makeData(n = 0:4,
                  count = c(754,9,8,4,1),
                  type = "P",
                  notes = bibentry(bibtype = "Article",
                                  title = "Glass particles in footwear of members of the public in south-eastern Australia---a survey",
                                  journal = "Forensic Science International",
                                  volume = "116",
                                  number = "2",
                                  pages = "149--156",
                                  year = "2001",
                                  doi = "https://doi.org/10.1016/S0379-0738(00)00355-8",
                                  author = c(as.person("C. Roux"),
                                             as.person("R. Kirk"),
                                             as.person("S. Benson"),
                                             as.person("T. Van Haren"),
                                             as.person("C.I. Petterd")
                                             )
                  ))
)

Ssurveys = list(
  jackson = makeData(n = 1,
                     count = 6,
                     type = "S",
                     notes = bibentry(bibtype = "Article",
                                      title = "A survey of glass found on the headwear and head hair of a random population vs. people working with glass",
                                      journal = "Forensic Science International",
                                      volume = "226",
                                      number = "1",
                                      pages = "125--131",
                                      year = "2013",
                                      doi = "https://doi.org/10.1016/j.forsciint.2012.12.017",
                                      author = c(
                                        person("F.", "Jackson"),
                                        person("P.", "Maynard"),
                                        person("K.", "Cavanagh-Steer"),
                                        person("T.", "Dusting"),
                                        person("C.", "Roux")
                                      )
                     )),
  lau = makeData(n = 1,
                 count = 2,
                 type = "S",
                 notes = bibentry(bibtype = "Article",
                                  author = c(as.person("L. Lau"),
                                             as.person("A. D. Beveridge"),
                                             as.person("B. C. Callowhill"),
                                             as.person("N. Conners"),
                                             as.person("K. Foster"),
                                             as.person("R. J. Groves"),
                                             as.person("K. N. Ohashi"),
                                             as.person("A. M. Sumner"),
                                             as.person("H. Wong")
                                  ),
                                  title = "The Frequency of Occurrence of Paint and Glass on the Clothing of High School Students",
                                  journal = "Canadian Society of Forensic Science Journal",
                                  volume = "30",
                                  number = "4",
                                  pages = "233-240",
                                  year  = "1997",
                                  doi = "10.1080/00085030.1997.10757103"
                 )),
  pettard = makeData(n = 1,
                     count = 6,
                     type = "S",
                     notes = bibentry(bibtype = "InProceedings",
                                      author = c(person(given = "C. I.", family = "Petterd"),
                                                 person(given = "I.", family = "McCallum"),
                                                 person(given = "L.", family = "Bradford"),
                                                 person(given = "K.", family = "Brinch"),
                                                 person(given = "S.", family = "Stewart")
                                      ),
                                      year = "1998",
                                      title = "Glass particles in the clothing of the general population in Canberra---a survey",
                                      booktitle = "Proceedings of the 14th International Symposium on the Forensic Sciences",
                                      date = "12--16 October 1998",
                                      city = "Adelaide, South Australia",
                                      publisher = "Australian and New Zealand Forensic Science Society"
                     )),
  ross = makeData(n = 1,
                  count = 2,
                  type = "S",
                  notes = bibentry(bibtype = "InProceedings",
                                   author = c(person(given = "P.", family = "Ross"),
                                              person(given = "H.", family = "Nguyen")
                                   ),
                                   year = "1998",
                                   title = "A survey of clothing for the presence of glass fragments",
                                   booktitle = "Proceedings of the 14th International Symposium on the Forensic Sciences",
                                   date = "12--16 October 1998",
                                   city = "Adelaide, South Australia",
                                   publisher = "Australian and New Zealand Forensic Science Society"
                  )),
  roux = makeData(n = 1:7,
                  count = c(25,10,3,6,1,1,1),
                  type = "S",
                  notes = bibentry(bibtype = "Article",
                                   title = "Glass particles in footwear of members of the public in south-eastern Australia---a survey",
                                   journal = "Forensic Science International",
                                   volume = "116",
                                   number = "2",
                                   pages = "149--156",
                                   year = "2001",
                                   doi = "https://doi.org/10.1016/S0379-0738(00)00355-8",
                                   author = c(as.person("C. Roux"),
                                              as.person("R. Kirk"),
                                              as.person("S. Benson"),
                                              as.person("T. Van Haren"),
                                              as.person("C.I. Petterd")
                                   )
                  ))
)

save("Psurveys", file = "data/Psurveys.rda")
save("Ssurveys", file = "data/Ssurveys.rda")

