% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fishtree_complete_phylogeny}
\alias{fishtree_complete_phylogeny}
\title{Get complete (stochastically-resolved) phylogenies from the Fish Tree of Life}
\usage{
fishtree_complete_phylogeny(
  species,
  rank,
  mc.cores = getOption("mc.cores", 1L)
)
}
\arguments{
\item{species}{(Optionally) subset the results based on a vector of species names.}

\item{rank}{(Optionally) subset the results based on the supplied taxonomic rank.}

\item{mc.cores}{Number of cores to use in \link[parallel]{mclapply} when subsetting the tree (default `1`)}
}
\value{
An object of class `"multiPhylo"` that should probably not be used for analyses of trait evolution, including (but not limited to) \link[ape]{pic}, \link[ape]{ace}, \link[ape]{corBrownian}, \link[diversitree]{make.bisse}, or \link[hisse]{hisse}.
}
\description{
Retrieves a complete phylogeny generated by stochastic polytomy resolution via the Fish Tree of Life API. If neither `species` nor `rank` are specified, returns the entire phylogeny. See Rabosky et al. (2018) and Chang et al. (2019) for details on how these phylogenies were built using stochastic polytomy resolution. WARNING: These phylogenies should generally not be used for downstream analyses of trait evolution. See Rabosky (2015) for details.
}
\examples{
\dontrun{
tree <- fishtree_complete_phylogeny(rank = "Acanthuridae")
sampled_tips <- fishtree_phylogeny(rank = "Acanthuridae")$tip.label
all_tips <- tree[[1]]$tip.label
new_tips <- setdiff(all_tips, sampled_tips)
par(mfrow = c(2,2))
for (ii in 1:4) {
  plot(tree[[ii]], show.tip.label = FALSE, no.margin = TRUE)
  ape::tiplabels(pch = 19, col = ifelse(tree[[ii]]$tip.label \%in\% new_tips, "red", NA))
}
}
}
\references{
Rabosky, D. L. (2015). No substitute for real data: A cautionary note on the use of phylogenies from birth-death polytomy resolvers for downstream comparative analyses. Evolution, 69(12), 3207–3216. doi:10.1111/evo.12817

Rabosky, D. L., Chang, J., Title, P. O., Cowman, P. F., Sallan, L., Friedman, M., Kashner, K., Garilao, C., Near, T. J., Coll, M., Alfaro, M. E. (2018). An inverse latitudinal gradient in speciation rate for marine fishes. Nature, 559(7714), 392–395. doi:10.1038/s41586-018-0273-1

Chang, J., Rabosky, D. L., & Alfaro, M. E. (2019). Estimating diversification rates on incompletely-sampled phylogenies: theoretical concerns and practical solutions. Systematic Biology. doi:10.1093/sysbio/syz081

Enhanced polytomy resolution strengthens evidence for global gradient in speciation rate for marine fishes. \url{https://fishtreeoflife.org/rabosky-et-al-2018-update/}
}
