% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchange_custom_token.R
\name{exchange_custom_token}
\alias{exchange_custom_token}
\title{Exchange custom token for an ID and refresh token}
\usage{
exchange_custom_token(token)
}
\arguments{
\item{token}{String. A Firebase Auth custom token from which to create
an ID and refresh token pair}
}
\value{
A named list with the following items:
\itemize{
\item \code{idToken}:	A Firebase Auth ID token generated from the provided custom token.
\item \code{refreshToken}:	A Firebase Auth refresh token generated from the provided custom token.
\item \code{expiresIn}:	The number of seconds in which the ID token expires.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Exchanges a custom Auth token for an ID and refresh token
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-verify-custom-token}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  exchange_custom_token(token = "your-firebase-auth-custom-token")
}
}
