% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{weekly_planned_capacity_P1_south_to_north}
\alias{weekly_planned_capacity_P1_south_to_north}
\title{Planned weekly capacity from south to north defined by Fingrid}
\usage{
weekly_planned_capacity_P1_south_to_north(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains planned weekly capacity on
North-South cut in Finland (cut P1) from South to North. Planned outages
are included in the weekly capacity, information is not updated after
disturbances.
}
\description{
Check https://data.fingrid.fi/en/dataset/planned-weekly-capacity-from-south-to-north-defined-by-fingrid
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- weekly_planned_capacity_P1_south_to_north(start_time = start,
                                                end_time = end,
                                                user_key = key)
summary(df)
}
}
