% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{procured_aFRR_capacity_up_price}
\alias{procured_aFRR_capacity_up_price}
\title{Procured a FRR capacity price, up}
\usage{
procured_aFRR_capacity_up_price(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains volume weighted average price
for procured upward automatic Frequency Restoration Reserve (aFRR)
capacity, in EUR/MW.
}
\description{
Check https://data.fingrid.fi/en/dataset/procured-a-frr-capacity-price-up
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- procured_aFRR_capacity_up_price(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
