% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{day_ahead_transmission_capacity_FI_to_EE}
\alias{day_ahead_transmission_capacity_FI_to_EE}
\title{Day-ahead transmission capacity FI-EE}
\usage{
day_ahead_transmission_capacity_FI_to_EE(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains day-ahead transmission capacity
from Finland (FI) to Estonia (EE). Transmission capacity is given hourly
for every hour of the next day. Each hour is given one value. Day-ahead
transmission capacity Fingrid will publish every day in the afternoon.
This capacity will not changed after publication. Transmission capacity
mean the capability of the electricity system to supply electricity to
the market without compromising the system security.
}
\description{
Check https://data.fingrid.fi/en/dataset/indra-day-transmission-capacity-fi-ee
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- day_ahead_transmission_capacity_FI_to_EE(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
