% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiles.R
\name{profiles}
\alias{profiles}
\title{Live profiles}
\usage{
profiles(ProfileID = NULL, ProfileName = NULL, path)
}
\arguments{
\item{ProfileID}{Numeric vector, id of profiles of interest}

\item{ProfileName}{Character vector, full name of profile(s)}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of live profile ids and names along with their domain
  names and ids.
}
\description{
Outputs a data frame of live profiles that data are available for in
Fingertips \url{http://fingertips.phe.org.uk/}
}
\examples{
\dontrun{
# Returns a complete data frame of domains and their profiles
profiles()}

# Returns a data frame of all of the domains in the Public Health Outcomes Framework
profiles(ProfileName = "Public Health Outcomes Framework")
}
\seealso{
\code{\link{area_types}} for area type  and their parent mappings,
  \code{\link{indicators}} for indicator lookups,
  \code{\link{indicator_metadata}} for indicator metadata,
  \code{\link{deprivation_decile}} for deprivation decile lookups,
  \code{\link{category_types}} for category lookups,
  \code{\link{indicator_areatypes}} for indicators by area types lookups,
  \code{\link{indicators_unique}} for unique indicatorids and their names,
  \code{\link{nearest_neighbours}} for a vector of nearest neighbours for an area and
  \code{\link{indicator_order}} for the order indicators are presented on the
  Fingertips website within a Domain

Other lookup functions: 
\code{\link{area_types}()},
\code{\link{category_types}()},
\code{\link{deprivation_decile}()},
\code{\link{indicator_areatypes}()},
\code{\link{indicator_metadata}()},
\code{\link{indicator_order}()},
\code{\link{indicators_unique}()},
\code{\link{indicators}()},
\code{\link{nearest_neighbours}()}
}
\concept{lookup functions}
